package gov.va.med.mhv.sm.admin.enums;

public enum ReportingPeriodUnitsEnum {

	MINUTES (0L, "Minutes"),
	HOURS (1L, "Hours"),
	DAYS (2L, "Days");

	private Long id;
	private String name;

	private ReportingPeriodUnitsEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public static ReportingPeriodUnitsEnum valueOf(Long value){
		for(ReportingPeriodUnitsEnum f : ReportingPeriodUnitsEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("No such reporting period units found.");
	}

}
